#include <avr/io.h>
#include <avr/eeprom.h>
#include <util/delay.h>
#define KEY_PRESSED (!(PIND & (1 << PD0)))
uint8_t EEMEM data = 0x00;

int main(void)
{
 DDRB = 0xFF; 
 _delay_ms(1000);
 uint8_t value = eeprom_read_byte(&data);
 PORTB = value;
 while(1)
 { 
  if (KEY_PRESSED) 
  {
   value++; 
   PORTB = value;
   eeprom_update_byte(&data, value);
   _delay_ms(200);
  }
 }
 return 0;
}